IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.[CP_Listas_Precios_Precio_Nuevo_Actualizar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Listas_Precios_Precio_Nuevo_Actualizar
END
GO

CREATE  PROCEDURE [dbo].[CP_Listas_Precios_Precio_Nuevo_Actualizar]  @NroLista int , @HacerBackup tinyint
AS

DECLARE @Mensaje			VARCHAR(100)
		,@Id_Trans_Nueva	INT
		,@Descripcion		VARCHAR(100)
		,@Id_Valor			INT
		,@Comprobante_Nro	INT
		,@ListaBakcup       INT
		,@FECHA             DATETIME
		,@NoActualPrecioCero TINYINT


 DECLARE @Respuesta Table (
      ErrorNumber    int,
	  ErrorSeverity  INT,
	  ErrorState     INT,
	  ErrorProcedure INT,
	  ErrorLine      INT, 
      ErrorMessage   VARCHAR(100)
	  )		

BEGIN TRY
	BEGIN TRAN
	SET @NoActualPrecioCero = dbo.CF_xParam('No_Act_New_pcio_0')


	/*** Si solo aactualiza los precios dif. cero y no tiene nada para actualizar, no hago nada ----7/9/23  ***/
	IF @NoActualPrecioCero = 1 AND (SELECT COUNT(*) FROM Prod_Listas_Precios_Items WHERE Id_Lista_Precio = @NroLista AND Precio_Nuevo <> 0) = 0
	BEGIN
		COMMIT
		SET @Mensaje = 'Nada para actualizar'
		SELECT	 0					AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,@Mensaje			AS ErrorMessage
        RETURN 0
    END 
	/*****************fin de control de si hay algo para actualizar *****************/   
	


	SELECT @ListaBakcup = ISNULL(Id_Lista_Precio_Backup,0)
			FROM  Prod_Listas_Precios
			WHERE Id_Lista_Precio = @NroLista
				     
		    
	IF @HacerBackup = 1
	BEGIN
		SELECT * INTO #COPIA FROM Prod_Listas_Precios_Items WHERE Id_Lista_Precio = @NroLista
		--PRINT(@ListaBakcup)
		IF @ListaBakcup <> 0
			BEGIN
				PRINT 'TIENE LISTA BK'
				DELETE Prod_Listas_Precios_Items WHERE Id_Lista_Precio = @ListaBakcup
				UPDATE #COPIA SET Id_Lista_Precio = @ListaBakcup
			END
		ELSE
			BEGIN
				PRINT 'NO TIENE LISTA BK'
				SET @ListaBakcup = (SELECT MAX(Id_Lista_Precio)+1 FROM Prod_Listas_Precios) 
				PRINT @ListaBakcup

				SELECT * INTO #NUEVA_LISTA FROM Prod_Listas_Precios WHERE Id_Lista_Precio = @NroLista

				UPDATE #NUEVA_LISTA SET Id_Lista_Precio = @ListaBakcup, ACTIVO = 0, DESCRIPCION = 'COPIA BK ' + LTRIM(RTRIM(DESCRIPCION))
				INSERT INTO Prod_Listas_Precios
						SELECT * FROM #NUEVA_LISTA
				UPDATE #COPIA SET Id_Lista_Precio = @ListaBakcup
				DROP TABLE #NUEVA_LISTA
            END				   
			
		INSERT INTO Prod_Listas_Precios_Items
				SELECT * FROM #COPIA

		DROP TABLE #COPIA 
	END		
		 
    IF @NoActualPrecioCero = 1
	BEGIN
			UPDATE Prod_Listas_Precios_Items	SET Fecha_Desde = Getdate(),Precio = Precio_Nuevo  
											WHERE Id_Lista_Precio = @NroLista AND Precio <> Precio_Nuevo AND Precio_Nuevo <> 0
  			UPDATE Prod_Listas_Precios_Items	SET Precio_Nuevo = 0
											WHERE Id_Lista_Precio = @NroLista AND Precio_Nuevo <> 0

			UPDATE Prod_Listas_Precios			SET Fecha_desde = Fecha_Desde_Nueva,Fecha_Hasta = Fecha_Hasta_Nueva 
											WHERE Id_Lista_Precio = @NroLista
			UPDATE Prod_Listas_Precios			SET Fecha_Desde_Nueva = NULL,Fecha_Hasta_Nueva = Null 
											WHERE Id_Lista_Precio = @NroLista
	END	
	ELSE
	BEGIN
			UPDATE Prod_Listas_Precios_Items	SET Fecha_Desde = Getdate(),Precio = Precio_Nuevo  
											WHERE Id_Lista_Precio = @NroLista AND Precio <> Precio_Nuevo
  			UPDATE Prod_Listas_Precios_Items	SET Precio_Nuevo = 0
											WHERE Id_Lista_Precio = @NroLista AND Precio_Nuevo <> 0

			UPDATE Prod_Listas_Precios			SET Fecha_desde = Fecha_Desde_Nueva,Fecha_Hasta = Fecha_Hasta_Nueva		
											WHERE Id_Lista_Precio = @NroLista
			UPDATE Prod_Listas_Precios			SET Fecha_Desde_Nueva = NULL,Fecha_Hasta_Nueva = Null 
											WHERE Id_Lista_Precio = @NroLista
	END	
 


	COMMIT
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,@Mensaje			AS ErrorMessage


END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   

-- EXEC CP_Listas_Precios_Precio_Nuevo_Actualizar 1001,1
